<?php
// public_html/api/cart_action.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/src/Models/Cart.php';

if (!isAjax()) exit;

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Please Login first', 'redirect' => '/public_html/user/auth/login-signup.php']);
    exit;
}

$cart = new Cart();
$userId = $_SESSION['user_id'];
$action = $_POST['action'] ?? '';

if ($action === 'add') {
    $variantId = $_POST['variant_id'];
    $result = $cart->add($userId, $variantId, 1);
    
    // Update session count
    $cartData = $cart->get($userId);
    $_SESSION['cart_count'] = $cartData['count'];
    
    echo json_encode($result);
}

if ($action === 'remove') {
    $itemId = $_POST['item_id'];
    $result = $cart->remove($userId, $itemId);
    
    $cartData = $cart->get($userId);
    $_SESSION['cart_count'] = $cartData['count'];
    
    echo json_encode($result);
}
