<?php
// public_html/admin/website/settings.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';
require_once ROOT_PATH . '/src/Models/Settings.php';

$settingsModel = new Settings($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf()) die("CSRF Error");
    
    foreach ($_POST['settings'] as $key => $val) {
        $settingsModel->update($key, trim($val));
    }
    $success = "Settings updated successfully.";
}

$data = $settingsModel->getAll(); // Fetch all as Key-Value
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Settings | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Website Settings</h1>

        <?php if(isset($success)): ?>
            <div class="bg-green-500/10 border border-green-500 text-green-500 p-4 rounded-lg mb-6"><?php echo $success; ?></div>
        <?php endif; ?>

        <form method="POST" class="max-w-4xl space-y-8">
            <?php echo csrf_field(); ?>

            <!-- General -->
            <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <h3 class="font-bold text-blue-400 uppercase text-xs mb-4">General</h3>
                <div class="grid grid-cols-2 gap-6">
                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Site Name</label>
                        <input type="text" name="settings[site_name]" value="<?php echo e($data['site_name'] ?? SITE_NAME); ?>" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                    </div>
                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Maintenance Mode</label>
                        <select name="settings[maintenance_mode]" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                            <option value="0" <?php echo ($data['maintenance_mode'] ?? '0') == '0' ? 'selected' : ''; ?>>Live</option>
                            <option value="1" <?php echo ($data['maintenance_mode'] ?? '0') == '1' ? 'selected' : ''; ?>>Maintenance (Offline)</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Referral -->
            <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <h3 class="font-bold text-blue-400 uppercase text-xs mb-4">Referral System</h3>
                <div class="grid grid-cols-2 gap-6">
                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Referral Status</label>
                        <select name="settings[referral_enabled]" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                            <option value="1" <?php echo ($data['referral_enabled'] ?? '1') == '1' ? 'selected' : ''; ?>>Enabled</option>
                            <option value="0" <?php echo ($data['referral_enabled'] ?? '0') == '0' ? 'selected' : ''; ?>>Disabled</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Reward Amount (₹)</label>
                        <input type="number" name="settings[referral_bonus]" value="<?php echo e($data['referral_bonus'] ?? '50'); ?>" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                    </div>
                </div>
            </div>

            <!-- Support -->
            <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <h3 class="font-bold text-blue-400 uppercase text-xs mb-4">Support</h3>
                <div class="grid grid-cols-2 gap-6">
                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase mb-2">WhatsApp Enabled</label>
                        <select name="settings[whatsapp_enabled]" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                            <option value="1" <?php echo ($data['whatsapp_enabled'] ?? '1') == '1' ? 'selected' : ''; ?>>Yes</option>
                            <option value="0" <?php echo ($data['whatsapp_enabled'] ?? '0') == '0' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    <div>
                         <label class="block text-gray-400 text-xs font-bold uppercase mb-2">WhatsApp Number</label>
                        <input type="text" name="settings[whatsapp_number]" value="<?php echo e($data['whatsapp_number'] ?? ''); ?>" placeholder="+91..." class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 outline-none">
                    </div>
                </div>
            </div>

            <button type="submit" class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 px-8 rounded-xl shadow-lg transition-transform active:scale-95">
                Save Settings
            </button>
        </form>
    </main>
</body>
</html>
