<?php
// public_html/admin/website/coupons.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';

// Handle Create
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code'])) {
    if (!verify_csrf()) die("CSRF");
    
    $code = strtoupper(trim($_POST['code']));
    $type = $_POST['type']; // 'flat' or 'percent'
    $value = (float)$_POST['value'];
    
    // Simple logic: Insert into coupons table (create if not exists)
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS coupons (
            id INT AUTO_INCREMENT PRIMARY KEY,
            code VARCHAR(50) UNIQUE,
            type ENUM('flat', 'percent'),
            value DECIMAL(10,2),
            is_active TINYINT DEFAULT 1
        )");
        
        $stmt = $pdo->prepare("INSERT INTO coupons (code, type, value) VALUES (?, ?, ?)");
        $stmt->execute([$code, $type, $value]);
        $success = "Coupon created.";
    } catch (Exception $e) {
        $error = "Error: " . $e->getMessage();
    }
}

// Handle Delete
if (isset($_POST['delete_id'])) {
    $pdo->prepare("DELETE FROM coupons WHERE id = ?")->execute([$_POST['delete_id']]);
}

$coupons = [];
try {
    $coupons = $pdo->query("SELECT * FROM coupons ORDER BY id DESC")->fetchAll();
} catch (Exception $e) {}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Coupons | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Manage Coupons</h1>
        
        <?php if(isset($success)): ?><div class="bg-green-500/10 text-green-500 p-4 rounded mb-6"><?php echo $success; ?></div><?php endif; ?>
        <?php if(isset($error)): ?><div class="bg-red-500/10 text-red-500 p-4 rounded mb-6"><?php echo $error; ?></div><?php endif; ?>

        <!-- Create Form -->
        <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700 mb-8">
            <h3 class="font-bold mb-4">Create New Coupon</h3>
            <form method="POST" class="flex gap-4 items-end">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Code</label>
                    <input type="text" name="code" required placeholer="WELCOME50" class="bg-gray-700 rounded px-3 py-2 w-48 uppercase">
                </div>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Type</label>
                    <select name="type" class="bg-gray-700 rounded px-3 py-2">
                        <option value="flat">Flat Amount (₹)</option>
                        <option value="percent">Percentage (%)</option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Value</label>
                    <input type="number" name="value" required class="bg-gray-700 rounded px-3 py-2 w-32">
                </div>
                <button class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-6 rounded">Create</button>
            </form>
        </div>

        <!-- List -->
        <div class="bg-gray-800 rounded-2xl border border-gray-700 overflow-hidden">
            <table class="w-full text-left text-sm text-gray-400">
                <thead class="bg-gray-900 uppercase font-bold text-xs text-gray-500">
                    <tr>
                        <th class="px-6 py-4">Code</th>
                        <th class="px-6 py-4">Discount</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php if(empty($coupons)): ?><tr><td colspan="4" class="px-6 py-4 text-center">No coupons yet.</td></tr><?php endif; ?>
                    <?php foreach($coupons as $c): ?>
                    <tr>
                        <td class="px-6 py-4 font-mono font-bold text-white"><?php echo e($c['code']); ?></td>
                        <td class="px-6 py-4 font-bold text-green-400">
                            <?php echo $c['type'] === 'flat' ? '₹' . $c['value'] : $c['value'] . '% OFF'; ?>
                        </td>
                        <td class="px-6 py-4"><span class="bg-green-500/10 text-green-500 px-2 py-1 rounded text-xs">Active</span></td>
                        <td class="px-6 py-4">
                            <form method="POST" onsubmit="return confirm('Delete?');">
                                <input type="hidden" name="delete_id" value="<?php echo $c['id']; ?>">
                                <button class="text-red-400 hover:text-red-300">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
