<?php
// public_html/admin/website/banners.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';

// Logic: We'll overwrite a 'home_banner.jpg' in uploads or update a setting
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['banner'])) {
    if (!verify_csrf()) die("CSRF");
    
    // Simulate Upload
    // In Real App: move_uploaded_file(...)
    $success = "Banner uploaded successfully (Simulated).";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Banners | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Manage Banners</h1>
        
        <?php if(isset($success)): ?><div class="bg-green-500/10 text-green-500 p-4 rounded mb-6"><?php echo $success; ?></div><?php endif; ?>

        <div class="bg-gray-800 p-8 rounded-2xl border border-gray-700 max-w-2xl">
            <h3 class="font-bold mb-6">Homepage Main Banner</h3>
            
            <div class="aspect-[16/9] bg-gray-700 rounded-xl mb-6 overflow-hidden relative">
                <img src="https://images.unsplash.com/photo-1483985988355-763728e1935b?auto=format&fit=crop&w=800&q=80" class="w-full h-full object-cover opacity-50">
                <div class="absolute inset-0 flex items-center justify-center">
                    <span class="text-sm font-bold bg-black/50 px-4 py-2 rounded">Current Preview</span>
                </div>
            </div>

            <form method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <label class="block text-xs uppercase font-bold text-gray-500 mb-2">Upload New Image</label>
                <input type="file" name="banner" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-bold file:bg-gray-700 file:text-blue-400 hover:file:bg-gray-600">
                
                <button class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 px-8 rounded-xl shadow-lg mt-6">
                    Update Banner
                </button>
            </form>
        </div>
    </main>
</body>
</html>
