<?php
// public_html/admin/wallet/wallet-list.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';

// Adjust Balance Action
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'])) {
    if (!verify_csrf()) die("CSRF Error");
    
    $userId = $_POST['user_id'];
    $amount = (float)$_POST['amount'];
    $type = $_POST['type']; // 'credit' or 'debit'
    $reason = trim($_POST['reason']);
    
    if ($type === 'debit') $amount = -$amount;

    try {
        $pdo->beginTransaction();

        // 1. Update User
        $stmt = $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?");
        $stmt->execute([$amount, $userId]);

        // 2. Log Transaction
        $stmt = $pdo->prepare("INSERT INTO wallet_transactions (user_id, amount, type, description, created_at) VALUES (?, ?, 'admin_adjust', ?, NOW())");
        $desc = "Admin Adjustment: " . $reason;
        $stmt->execute([$userId, $amount, $desc]);

        $pdo->commit();
        $success = "Wallet adjusted successfully.";
    } catch (Exception $e) {
        $pdo->rollBack();
        $error = "Failed: " . $e->getMessage();
    }
}

// Fetch Users with Balance > 0 OR Recent Transactions (simplified to all users for now)
$page = $_GET['page'] ?? 1;
$stmt = $pdo->query("SELECT id, full_name, phone, wallet_balance FROM users ORDER BY wallet_balance DESC LIMIT 50");
$users = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Wallet | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Wallet Management</h1>

        <?php if(isset($success)): ?>
             <div class="bg-green-500/10 border border-green-500 text-green-500 p-4 rounded-lg mb-6"><?php echo $success; ?></div>
        <?php endif; ?>

        <!-- Credit/Debit Modal (Simple inline form for demo) -->
        <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700 mb-8">
            <h3 class="font-bold text-lg mb-4">Manual Adjustment</h3>
            <form method="POST" class="flex gap-4 items-end">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">User ID</label>
                    <input type="number" name="user_id" required class="bg-gray-700 rounded px-3 py-2 w-24">
                </div>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Type</label>
                    <select name="type" class="bg-gray-700 rounded px-3 py-2">
                        <option value="credit">Credit (+)</option>
                        <option value="debit">Debit (-)</option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Amount</label>
                    <input type="number" name="amount" required step="0.01" class="bg-gray-700 rounded px-3 py-2 w-32">
                </div>
                <div class="flex-1">
                    <label class="block text-xs uppercase font-bold text-gray-500 mb-1">Reason</label>
                    <input type="text" name="reason" required placeholder="Refund #123 / Bonus" class="bg-gray-700 rounded px-3 py-2 w-full">
                </div>
                <button class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-6 rounded">Apply</button>
            </form>
        </div>

        <div class="bg-gray-800 rounded-2xl border border-gray-700 overflow-hidden">
            <table class="w-full text-left text-sm text-gray-400">
                <thead class="bg-gray-900 uppercase font-bold text-xs text-gray-500">
                    <tr>
                        <th class="px-6 py-4">ID</th>
                        <th class="px-6 py-4">User</th>
                        <th class="px-6 py-4">Balance</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php foreach($users as $u): ?>
                    <tr class="hover:bg-gray-750">
                        <td class="px-6 py-4">#<?php echo $u['id']; ?></td>
                        <td class="px-6 py-4 font-bold text-white"><?php echo e($u['full_name']); ?> <span class="text-gray-500 font-normal">(<?php echo $u['phone']; ?>)</span></td>
                        <td class="px-6 py-4 font-bold text-green-400"><?php echo format_price($u['wallet_balance']); ?></td>
                        <td class="px-6 py-4 text-xs">
                           <!-- Could add View History link -->
                           <span class="text-gray-600">History (To Do)</span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
