<?php
// public_html/admin/users/user-list.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';

// Block/Unblock Action
if (isset($_POST['toggle_block_id'])) {
    if (!verify_csrf()) die("CSRF Error");
    $uid = $_POST['toggle_block_id'];
    $currentStatus = $_POST['current_status']; 
    $newStatus = $currentStatus == 1 ? 0 : 1; // 0=Blocked
    
    $stmt = $pdo->prepare("UPDATE users SET is_active = ? WHERE id = ?");
    $stmt->execute([$newStatus, $uid]);
    $success = "User status updated.";
}

// Fetch Users
$page = $_GET['page'] ?? 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$stmt = $pdo->query("SELECT * FROM users ORDER BY created_at DESC LIMIT $limit OFFSET $offset");
$users = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Users | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Customers</h1>

        <?php if(isset($success)): ?>
             <div class="bg-green-500/10 border border-green-500 text-green-500 p-4 rounded-lg mb-6"><?php echo $success; ?></div>
        <?php endif; ?>

        <div class="bg-gray-800 rounded-2xl border border-gray-700 overflow-hidden">
            <table class="w-full text-left text-sm text-gray-400">
                <thead class="bg-gray-900 uppercase font-bold text-xs text-gray-500">
                    <tr>
                        <th class="px-6 py-4">ID</th>
                        <th class="px-6 py-4">Customer</th>
                        <th class="px-6 py-4">Wallet</th>
                        <th class="px-6 py-4">Referred By</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php foreach($users as $u): ?>
                    <tr class="hover:bg-gray-750 transition-colors">
                        <td class="px-6 py-4">#<?php echo $u['id']; ?></td>
                        <td class="px-6 py-4 text-white">
                            <div class="font-bold"><?php echo e($u['full_name']); ?></div>
                            <div class="text-xs text-gray-500"><?php echo $u['phone']; ?></div>
                        </td>
                        <td class="px-6 py-4 font-bold text-green-400"><?php echo format_price($u['wallet_balance']); ?></td>
                        <td class="px-6 py-4"><?php echo $u['referred_by'] ? '#' . $u['referred_by'] : '-'; ?></td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded text-xs font-bold uppercase <?php echo $u['is_active'] ? 'bg-green-500/10 text-green-500' : 'bg-red-500/10 text-red-500'; ?>">
                                <?php echo $u['is_active'] ? 'Active' : 'Blocked'; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <form method="POST" onsubmit="return confirm('Are you sure?');">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="toggle_block_id" value="<?php echo $u['id']; ?>">
                                <input type="hidden" name="current_status" value="<?php echo $u['is_active']; ?>">
                                <?php if($u['is_active']): ?>
                                    <button class="text-red-400 hover:text-red-300 font-bold">Block</button>
                                <?php else: ?>
                                    <button class="text-green-400 hover:text-green-300 font-bold">Unblock</button>
                                <?php endif; ?>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
