<?php
// public_html/admin/support/view.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminSupport.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

$id = $_GET['id'] ?? 0;
$as = new AdminSupport();
$ticket = $as->getTicketDetails($id);

if (!$ticket) die("Ticket not found");

// Handle Reply
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $msg = trim($_POST['message']);
    if ($msg) {
        $as->reply($id, $msg);
        header("Location: view.php?id=$id");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ticket #<?php echo $id; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8 h-screen flex flex-col">
        <div class="mb-4">
             <a href="index.php" class="text-gray-500 hover:text-gray-800">&larr; Back to Tickets</a>
             <h2 class="text-2xl font-bold text-gray-800 mt-2"><?php echo htmlspecialchars($ticket['subject']); ?></h2>
             <p class="text-sm text-gray-500">User: <?php echo htmlspecialchars($ticket['full_name']); ?> | Status: <span class="uppercase font-bold"><?php echo $ticket['status']; ?></span></p>
        </div>

        <div class="flex-1 bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden flex flex-col">
            <!-- Messages -->
            <div class="flex-1 overflow-y-auto p-6 space-y-4 bg-gray-50">
                <?php foreach($ticket['messages'] as $m): ?>
                    <div class="flex <?php echo $m['is_admin'] ? 'justify-end' : 'justify-start'; ?>">
                        <div class="max-w-[70%] <?php echo $m['is_admin'] ? 'bg-blue-600 text-white' : 'bg-white text-gray-800 border border-gray-200'; ?> p-4 rounded-xl shadow-sm">
                            <?php if($m['is_admin']): ?>
                                <p class="text-xs text-blue-200 mb-1 font-bold">You</p>
                            <?php endif; ?>
                            
                            <?php if($m['attachment_url']): ?>
                                <a href="<?php echo $m['attachment_url']; ?>" target="_blank" class="block mb-2 text-xs underline opacity-80">View Attachment</a>
                            <?php endif; ?>
                            
                            <p class="text-sm leading-relaxed"><?php echo nl2br(htmlspecialchars($m['message'])); ?></p>
                            <p class="text-xs mt-2 opacity-50 text-right"><?php echo date('M d, h:i A', strtotime($m['created_at'])); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Reply Box -->
            <div class="p-4 bg-white border-t border-gray-100">
                <form method="POST" class="flex gap-4">
                    <textarea name="message" rows="2" placeholder="Write a reply..." class="flex-1 border border-gray-300 rounded-lg p-3 outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500"></textarea>
                    <button type="submit" class="bg-blue-600 text-white font-bold px-6 rounded-lg hover:bg-blue-700">Send</button>
                </form>
            </div>
        </div>
    </main>
</body>
</html>
