<?php
// public_html/admin/support/index.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Support.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

// TODO extend Support model for Admin to get ALL tickets
// For now we add a method to Support.php or create AdminSupport.php
// Let's create `AdminSupport` model for cleaner separation.
require_once ROOT_PATH . '/src/Models/Admin/AdminSupport.php';

$as = new AdminSupport();
$tickets = $as->getAllTickets();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Support Tickets</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Support Tickets</h2>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-600 font-bold uppercase text-xs">
                    <tr>
                        <th class="px-6 py-4">ID</th>
                        <th class="px-6 py-4">Subject</th>
                        <th class="px-6 py-4">User</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Last Update</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php foreach($tickets as $t): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm font-mono">#<?php echo $t['id']; ?></td>
                        <td class="px-6 py-4 font-medium"><?php echo htmlspecialchars($t['subject']); ?></td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo htmlspecialchars($t['full_name']); ?></td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded text-xs font-bold uppercase <?php echo $t['status'] === 'open' ? 'bg-green-100 text-green-600' : 'bg-gray-100 text-gray-500'; ?>"><?php echo $t['status']; ?></span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo date('M d', strtotime($t['updated_at'])); ?></td>
                        <td class="px-6 py-4">
                            <a href="view.php?id=<?php echo $t['id']; ?>" class="text-blue-600 hover:text-blue-800 font-bold text-sm">Reply</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
