<?php
// public_html/admin/returns/return-requests.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';
require_once ROOT_PATH . '/src/Models/Order.php'; // Reuse Order Model logic if possible

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf()) die("CSRF");
    $orderId = $_POST['order_id'];
    $action = $_POST['action']; // 'approve' or 'reject'

    try {
        $pdo->beginTransaction();
        
        if ($action === 'approve') {
            // 1. Update Order Status
            $stmt = $pdo->prepare("UPDATE orders SET order_status = 'returned' WHERE id = ?");
            $stmt->execute([$orderId]);

            // 2. Refund Wallet (Simple Logic)
            $stmt = $pdo->prepare("SELECT user_id, total_amount FROM orders WHERE id = ?");
            $stmt->execute([$orderId]);
            $order = $stmt->fetch();
            
            // Refund
            $stmt = $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?");
            $stmt->execute([$order['total_amount'], $order['user_id']]);
            
            // Log
            $stmt = $pdo->prepare("INSERT INTO wallet_transactions (user_id, amount, type, description, created_at) VALUES (?, ?, 'refund', ?, NOW())");
            $stmt->execute([$order['user_id'], $order['total_amount'], "Refund for Order #$orderId"]);

        } elseif ($action === 'reject') {
            // Just revert status to delivered or specific 'return_rejected' status
            $stmt = $pdo->prepare("UPDATE orders SET order_status = 'delivered' WHERE id = ?");
            $stmt->execute([$orderId]);
        }
        
        $pdo->commit();
        $success = "Return request processed.";

    } catch (Exception $e) {
        $pdo->rollBack();
        $error = $e->getMessage();
    }
}

// Fetch Pending Returns (Simulated with 'pending_return' status or just all for now)
// Note: In real app, we need a 'return_requested' status. 
// For now, let's assume we list all 'cancelled' or specific logic.
$stmt = $pdo->query("SELECT * FROM orders WHERE order_status = 'return_requested' ORDER BY updated_at DESC");
$returns = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Returns | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <h1 class="text-2xl font-bold mb-8">Return Requests</h1>

        <?php if(isset($success)): ?>
            <div class="bg-green-500/10 border border-green-500 text-green-500 p-4 rounded-lg mb-6"><?php echo $success; ?></div>
        <?php endif; ?>

        <?php if(empty($returns)): ?>
            <div class="bg-gray-800 p-8 rounded-2xl border border-gray-700 text-center text-gray-500">
                No pending return requests.
            </div>
        <?php else: ?>
            <div class="space-y-4">
                <?php foreach($returns as $r): ?>
                <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700 flex justify-between items-center">
                    <div>
                        <h3 class="font-bold text-white">Order #<?php echo $r['order_number']; ?></h3>
                        <p class="text-sm text-gray-400">Reason: Size Issue (Simulated)</p>
                        <p class="text-xs text-gray-500 mt-1">Refund Amount: <?php echo format_price($r['total_amount']); ?></p>
                    </div>
                    <div class="flex gap-4">
                        <form method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" value="<?php echo $r['id']; ?>">
                            <input type="hidden" name="action" value="reject">
                            <button class="text-red-400 hover:text-red-300 font-bold text-sm">Reject</button>
                        </form>
                        <form method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" value="<?php echo $r['id']; ?>">
                            <input type="hidden" name="action" value="approve">
                            <button class="bg-green-600 hover:bg-green-500 text-white font-bold py-2 px-6 rounded-lg shadow-lg">Approve Refund</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </main>
</body>
</html>
