<?php
// public_html/admin/products/index.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/src/Models/Product.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

// Fetch Products (Direct DB for simplicity as Product Model focuses on frontend formatting sometimes)
// Actually Product Model has getAllByCategory, but we want ALL.
$db = Database::getInstance()->getConnection();
$stmt = $db->query("SELECT p.*, c.name as cat_name FROM products p LEFT JOIN categories c ON p.category_id = c.id ORDER BY p.id DESC");
$products = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Products</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Products</h2>
            <a href="create.php" class="bg-blue-600 text-white font-bold px-4 py-2 rounded shadow hover:bg-blue-700">+ Add New</a>
        </div>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-600 font-bold uppercase text-xs">
                    <tr>
                        <th class="px-6 py-4">Image</th>
                        <th class="px-6 py-4">Name</th>
                        <th class="px-6 py-4">Category</th>
                        <th class="px-6 py-4">Price</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php foreach($products as $p): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                             <img src="<?php echo $p['image_url']; ?>" class="w-12 h-12 object-cover rounded bg-gray-200">
                        </td>
                        <td class="px-6 py-4 font-medium"><?php echo htmlspecialchars($p['name']); ?></td>
                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($p['cat_name']); ?></td>
                        <td class="px-6 py-4 font-bold">₹<?php echo $p['price']; ?></td>
                        <td class="px-6 py-4">
                            <a href="#" class="text-blue-600 hover:text-blue-800 text-sm font-bold">Edit</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
