<?php
// public_html/admin/products/create.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

require_once ROOT_PATH . '/includes/csrf.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

$db = Database::getInstance()->getConnection();
$cats = $db->query("SELECT * FROM categories")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    checkCsrf();
    
    $name = sanitize($_POST['name']);
    $desc = sanitize($_POST['description']);
    $price = (float)$_POST['price'];
    $catId = (int)$_POST['category_id'];
    $stock = (int)$_POST['stock'];
    
    // Image Upload
    $imageUrl = '/assets/images/placeholder.png'; // Default
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        try {
            $filename = secureUpload($_FILES['image'], PUBLIC_PATH . '/uploads');
            $imageUrl = '/public_html/uploads/' . $filename;
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    }

    if (!isset($error)) {
        try {
        $db->beginTransaction();
        
        // Insert Product
        $stmt = $db->prepare("INSERT INTO products (name, description, price, category_id, image_url) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $desc, $price, $catId, $imageUrl]);
        $prodId = $db->lastInsertId();
        
        // Insert Default Variant
        $vStmt = $db->prepare("INSERT INTO product_variants (product_id, color_name, stock_quantity) VALUES (?, 'Default', ?)");
        $vStmt->execute([$prodId, $stock]);
        
        $db->commit();
        header("Location: index.php");
        exit;
        
    } catch(Exception $e) {
        $db->rollBack();
        $error = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Product</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Add New Product</h2>
        
        <form method="POST" enctype="multipart/form-data" class="bg-white p-8 rounded-xl shadow-sm max-w-2xl">
            <?php echo csrfField(); ?>
            <div class="space-y-4">
                <div>
                    <label class="block text-gray-700 font-bold mb-1">Product Name</label>
                    <input type="text" name="name" required class="w-full border rounded p-2 outline-none focus:border-blue-500">
                </div>
                
                <div>
                    <label class="block text-gray-700 font-bold mb-1">Description</label>
                    <textarea name="description" rows="3" class="w-full border rounded p-2 outline-none focus:border-blue-500"></textarea>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-gray-700 font-bold mb-1">Price (₹)</label>
                        <input type="number" name="price" required class="w-full border rounded p-2 outline-none focus:border-blue-500">
                    </div>
                    <div>
                        <label class="block text-gray-700 font-bold mb-1">Stock Qty</label>
                        <input type="number" name="stock" value="100" required class="w-full border rounded p-2 outline-none focus:border-blue-500">
                    </div>
                </div>

                <div>
                    <label class="block text-gray-700 font-bold mb-1">Category</label>
                    <select name="category_id" class="w-full border rounded p-2 outline-none focus:border-blue-500">
                        <?php foreach($cats as $c): ?>
                            <option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 font-bold mb-1">Image</label>
                    <input type="file" name="image" class="w-full border rounded p-2">
                </div>

                <button type="submit" class="w-full bg-blue-600 text-white font-bold py-3 rounded hover:bg-blue-700 mt-4">Create Product</button>
            </div>
        </form>
    </main>
</body>
</html>