<?php
// public_html/admin/orders/view.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminOrder.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

$id = $_GET['id'] ?? 0;
$ao = new AdminOrder();

// Handle Status Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newStatus = $_POST['status'];
    $ao->updateOrderStatus($_SESSION['admin_id'], $id, $newStatus);
    $msg = "Order updated!";
}

$order = $ao->getOrderDetails($id);
if (!$order) die("Order not found");

$shipping = json_decode($order['shipping_address_json'], true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order #<?php echo $order['order_number']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8">
        <a href="index.php" class="text-gray-500 hover:text-gray-800 mb-4 inline-block">&larr; Back to Orders</a>
        
        <div class="flex justify-between items-start mb-6">
            <div>
                <h2 class="text-2xl font-bold text-gray-900">Order #<?php echo $order['order_number']; ?></h2>
                <p class="text-gray-500 text-sm">Placed on <?php echo date('F d, Y h:i A', strtotime($order['created_at'])); ?></p>
            </div>
            
            <!-- Status Update Form -->
            <form method="POST" class="bg-white p-4 rounded-lg shadow-sm flex items-center gap-2">
                <select name="status" class="bg-gray-50 border border-gray-200 rounded px-3 py-2 text-sm font-bold outline-none focus:border-blue-500">
                    <?php 
                    $opts = ['pending', 'processing', 'confirmed', 'shipped', 'delivered', 'cancelled', 'returned'];
                    foreach($opts as $opt): 
                    ?>
                    <option value="<?php echo $opt; ?>" <?php echo $order['order_status'] === $opt ? 'selected' : ''; ?>>
                        <?php echo ucfirst($opt); ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                <button type="submit" class="bg-blue-600 text-white text-sm font-bold px-4 py-2 rounded hover:bg-blue-700">Update</button>
            </form>
        </div>

        <?php if(isset($msg)): ?>
            <div class="bg-green-100 text-green-700 p-3 rounded mb-4"><?php echo $msg; ?></div>
        <?php endif; ?>

        <div class="grid grid-cols-3 gap-6">
            <!-- Items -->
            <div class="col-span-2 space-y-4">
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="font-bold text-gray-800 mb-4">Items</h3>
                    <?php foreach($order['items'] as $item): ?>
                    <div class="flex items-center justify-between py-3 border-b last:border-0 border-gray-100">
                        <div>
                            <p class="font-medium text-gray-900"><?php echo $item['product_name_snapshot']; ?></p>
                            <p class="text-sm text-gray-500">Qty: <?php echo $item['quantity']; ?></p>
                        </div>
                        <p class="font-bold">₹<?php echo $item['price_at_purchase']; ?></p>
                    </div>
                    <?php endforeach; ?>
                    <div class="mt-4 flex justify-between pt-4 border-t border-gray-100">
                        <span class="font-bold text-lg">Total</span>
                        <span class="font-bold text-lg text-rose-600">₹<?php echo number_format($order['total_amount']); ?></span>
                    </div>
                </div>
            </div>

            <!-- Customer Info -->
            <div class="space-y-4">
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="font-bold text-gray-800 mb-4">Customer Info</h3>
                    <p class="text-sm text-gray-600 mb-1">Name: <span class="font-medium text-gray-900"><?php echo $order['full_name']; ?></span></p>
                    <p class="text-sm text-gray-600 mb-1">Email: <span class="font-medium text-gray-900"><?php echo $order['email']; ?></span></p>
                    <p class="text-sm text-gray-600">Phone: <span class="font-medium text-gray-900"><?php echo $order['phone']; ?></span></p>
                </div>

                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="font-bold text-gray-800 mb-4">Shipping Address</h3>
                    <p class="text-sm text-gray-600 leading-relaxed">
                        <?php echo htmlspecialchars($shipping['full_name']); ?><br>
                        <?php echo htmlspecialchars($shipping['address_line1']); ?><br>
                        <?php echo htmlspecialchars($shipping['city']); ?>, <?php echo htmlspecialchars($shipping['state']); ?> <?php echo htmlspecialchars($shipping['pincode']); ?><br>
                        Phone: <?php echo htmlspecialchars($shipping['phone']); ?>
                    </p>
                </div>
                
                <div class="bg-white rounded-xl shadow-sm p-6">
                     <h3 class="font-bold text-gray-800 mb-2">Payment</h3>
                     <p class="text-sm capitalize font-medium text-gray-900">Method: <?php echo $order['payment_method']; ?></p>
                     <p class="text-sm capitalize font-medium text-gray-900">Status: 
                        <span class="<?php echo $order['payment_status'] === 'paid' ? 'text-green-600' : 'text-orange-600'; ?>">
                            <?php echo $order['payment_status']; ?>
                        </span>
                     </p>
                </div>
            </div>
        </div>
    </main>
</body>
</html>
