<?php
// public_html/admin/orders/index.php
require_once dirname(dirname(dirname(__DIR__))) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminOrder.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) header("Location: /admin/login.php");

$status = $_GET['status'] ?? 'all';
$page = $_GET['page'] ?? 1;

$ao = new AdminOrder();
$orders = $ao->getAllOrders($page, 20, $status);

$statuses = ['all', 'pending', 'confirmed', 'shipped', 'delivered', 'cancelled', 'returned'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Orders</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex">
    <?php include ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 w-full p-8">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Orders</h2>
            
            <!-- Filter -->
            <div class="flex gap-2">
                <?php foreach($statuses as $s): ?>
                    <a href="?status=<?php echo $s; ?>" class="px-3 py-1 rounded-full text-xs font-bold uppercase transition-colors <?php echo $status === $s ? 'bg-blue-600 text-white' : 'bg-white text-gray-600 hover:bg-gray-200'; ?>">
                        <?php echo $s; ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-600 font-bold uppercase text-xs">
                    <tr>
                        <th class="px-6 py-4">Order #</th>
                        <th class="px-6 py-4">Customer</th>
                        <th class="px-6 py-4">Total</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Date</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php foreach($orders as $o): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 font-mono text-sm"><?php echo $o['order_number']; ?></td>
                        <td class="px-6 py-4 border-b-0">
                            <div class="text-sm font-bold text-gray-900"><?php echo htmlspecialchars($o['full_name']); ?></div>
                            <div class="text-xs text-gray-500"><?php echo $o['phone']; ?></div>
                        </td>
                        <td class="px-6 py-4 font-bold text-gray-800">₹<?php echo number_format($o['total_amount']); ?></td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded text-xs font-bold uppercase 
                                <?php echo match($o['order_status']) {
                                    'pending' => 'bg-orange-100 text-orange-600',
                                    'confirmed' => 'bg-blue-100 text-blue-600',
                                    'delivered' => 'bg-green-100 text-green-600',
                                    'cancelled' => 'bg-red-100 text-red-600',
                                    default => 'bg-gray-100 text-gray-600'
                                }; ?>">
                                <?php echo $o['order_status']; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo date('M d, Y', strtotime($o['created_at'])); ?></td>
                        <td class="px-6 py-4">
                            <a href="view.php?id=<?php echo $o['id']; ?>" class="text-blue-600 hover:text-blue-800 font-bold text-sm">View</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <?php if(empty($orders)): ?>
                <div class="p-8 text-center text-gray-500">No orders found.</div>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
