<?php
// public_html/admin/login.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php'; // Bootstrap

// Check if already logged in
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    redirect('/admin/dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF Check (Optional for login but good practice)
    // if (!verify_csrf()) ... 

    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = 'Please enter username and password.';
    } else {
        // Rate Limit Check
        /* if (!check_rate_limit('admin_login', 5, 300)) {
             $error = "Too many attempts. Try again later.";
        } else */ {
            // Fetch Admin
            $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ?");
            $stmt->execute([$username]);
            $admin = $stmt->fetch();

            if ($admin && password_verify($password, $admin['password'])) {
                // Success
                session_regenerate_id(true);
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_name'] = $admin['name'];
                
                // Log Action (Optional)
                // log_admin_action($admin['id'], 'Login');

                redirect('/admin/dashboard.php');
            } else {
                $error = 'Invalid credentials.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login | <?php echo SITE_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 flex items-center justify-center h-screen px-4">

    <div class="w-full max-w-md bg-gray-800 p-8 rounded-2xl shadow-2xl border border-gray-700">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Admin Panel</h1>
            <p class="text-gray-400 text-sm">Sign in to manage your store</p>
        </div>

        <?php if($error): ?>
            <div class="bg-red-500/10 border border-red-500 text-red-500 text-sm p-3 rounded-lg mb-6 text-center">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-6">
            <div>
                <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Username</label>
                <input type="text" name="username" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 focus:border-blue-500 outline-none transition-colors" placeholder="admin">
            </div>
            
            <div>
                <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Password</label>
                <input type="password" name="password" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 focus:border-blue-500 outline-none transition-colors" placeholder="••••••••">
            </div>

            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 rounded-xl shadow-lg transition-transform active:scale-95">
                Login
            </button>
        </form>
    </div>

</body>
</html>
