<?php
// public_html/admin/layout/sidebar.php
// Assumes stats are not mandatory for display, or handled gracefully
?>
<aside class="w-64 bg-gray-800 border-r border-gray-700 flex-shrink-0 flex flex-col fixed h-full z-20">
    <div class="p-6 border-b border-gray-700">
        <h2 class="text-xl font-bold text-white tracking-widest">ADMIN<span class="text-blue-500">PANEL</span></h2>
    </div>
    
    <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
        <a href="<?php echo APP_URL; ?>/admin/dashboard.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
            Dashboard
        </a>
        
        <p class="px-3 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">Catalog</p>
        <a href="<?php echo APP_URL; ?>/admin/orders/order-list.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
           Orders
        </a>
        <a href="<?php echo APP_URL; ?>/admin/products/product-list.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
           Products
        </a>
         <a href="<?php echo APP_URL; ?>/admin/categories/category-list.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
           Categories
        </a>

        <p class="px-3 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">Users</p>
        <a href="<?php echo APP_URL; ?>/admin/users/user-list.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
            Customers
        </a>
        <a href="<?php echo APP_URL; ?>/admin/wallet/wallet-list.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
            Wallet
        </a>
        <a href="<?php echo APP_URL; ?>/admin/support/support-tickets.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
            Support
        </a>

        <p class="px-3 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">System</p>
         <a href="<?php echo APP_URL; ?>/admin/website/settings.php" class="admin-nav-link text-gray-400 hover:bg-gray-700 hover:text-white p-3 rounded flex items-center gap-3">
            Settings
        </a>
        <a href="<?php echo APP_URL; ?>/admin/logout.php" class="text-red-400 hover:bg-red-900/20 w-full text-left p-3 rounded flex items-center gap-3 mt-4">
            Logout
        </a>
    </nav>
</aside>
