<?php
// public_html/admin/index.php
require_once dirname(dirname(__DIR__)) . '/config/config.php';
require_once ROOT_PATH . '/config/database.php';
require_once ROOT_PATH . '/includes/helpers.php';
require_once ROOT_PATH . '/src/Models/Admin/AdminAuth.php';

session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: " . APP_URL . "/admin/login.php");
    exit;
}

$auth = new AdminAuth();
$stats = $auth->getDashboardStats();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

    <?php include __DIR__ . '/layout/sidebar.php'; ?>

    <main class="ml-64 p-8">
        <!-- Header -->
        <header class="flex justify-between items-center mb-8">
            <h2 class="text-3xl font-bold text-gray-800">Dashboard</h2>
            <div class="flex items-center gap-3 bg-white px-4 py-2 rounded-lg shadow-sm">
                <div class="w-8 h-8 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold">
                    <?php echo substr($_SESSION['admin_name'], 0, 1); ?>
                </div>
                <span class="text-sm font-medium text-gray-700"><?php echo htmlspecialchars($_SESSION['admin_name']); ?></span>
            </div>
        </header>

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Card 1 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <h3 class="text-gray-500 text-sm font-medium uppercase mb-2">Total Revenue</h3>
                <p class="text-3xl font-bold text-gray-900">₹<?php echo number_format($stats['revenue']); ?></p>
                <span class="text-green-500 text-sm font-medium mt-2 block">+12% from last month</span>
            </div>
            
            <!-- Card 2 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <h3 class="text-gray-500 text-sm font-medium uppercase mb-2">Total Orders</h3>
                <p class="text-3xl font-bold text-gray-900"><?php echo $stats['orders_count']; ?></p>
            </div>

            <!-- Card 3 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <h3 class="text-gray-500 text-sm font-medium uppercase mb-2">Pending Orders</h3>
                <p class="text-3xl font-bold text-orange-600"><?php echo $stats['pending_orders']; ?></p>
                <a href="/admin/orders?status=pending" class="text-blue-600 text-xs font-medium hover:underline">View Pending &rarr;</a>
            </div>

            <!-- Card 4 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <h3 class="text-gray-500 text-sm font-medium uppercase mb-2">Total Users</h3>
                <p class="text-3xl font-bold text-gray-900"><?php echo $stats['users_count']; ?></p>
            </div>
        </div>
        
        <!-- Quick Actions / Space for recent orders -->
        <div class="bg-white rounded-xl shadow-sm p-6">
             <h3 class="text-lg font-bold text-gray-800 mb-4">Recent Activity</h3>
             <p class="text-gray-500 text-sm">Detailed logs coming soon.</p>
        </div>

    </main>
</body>
</html>
