<?php
// public_html/admin/dashboard.php
require_once dirname(dirname(__DIR__)) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php'; // Guard
require_once ROOT_PATH . '/src/Models/Admin.php';

$adminModel = new Admin($pdo);
$stats = $adminModel->getDashboardStats();
$recentOrders = $adminModel->getRecentOrders(5);

$pageTitle = 'Dashboard';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard | Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .admin-nav-link { display: flex; align-items: center; gap: 0.75rem; padding: 0.75rem 1rem; border-radius: 0.5rem; color: #9CA3AF; transition: all 0.2s; }
        .admin-nav-link:hover, .admin-nav-link.active { background-color: #1F2937; color: #FFFFFF; }
    </style>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">

    <!-- Sidebar -->
    <aside class="w-64 bg-gray-800 border-r border-gray-700 flex-shrink-0 flex flex-col fixed h-full z-20">
        <div class="p-6 border-b border-gray-700">
            <h2 class="text-xl font-bold text-white tracking-widest">ADMIN<span class="text-blue-500">PANEL</span></h2>
        </div>
        
        <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
            <a href="dashboard.php" class="admin-nav-link active">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path></svg>
                Dashboard
            </a>
            
            <p class="px-4 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">Store</p>
            <a href="orders/order-list.php" class="admin-nav-link">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                Orders
            </a>
            <a href="products/product-list.php" class="admin-nav-link">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path></svg>
                Products
            </a>
             <a href="categories/category-list.php" class="admin-nav-link">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path></svg>
                Categories
            </a>

            <p class="px-4 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">Users</p>
            <a href="users/user-list.php" class="admin-nav-link">
                 <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path></svg>
                Customers
            </a>
            <a href="wallet/wallet-list.php" class="admin-nav-link">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg>
                Wallet
            </a>
            <a href="support/support-tickets.php" class="admin-nav-link">
                 <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                Support <span class="ml-auto bg-red-600 text-white text-[10px] px-2 rounded-full"><?php echo $stats['open_tickets']; ?></span>
            </a>

            <p class="px-4 pt-4 pb-2 text-xs font-bold text-gray-500 uppercase">System</p>
             <a href="website/settings.php" class="admin-nav-link">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                Settings
            </a>
            <a href="logout.php" class="admin-nav-link text-red-400 hover:bg-red-900/20 hover:text-red-400">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                Logout
            </a>
        </nav>
    </aside>

    <!-- Content -->
    <main class="ml-64 flex-1 p-8">
        
        <!-- Header -->
        <header class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-2xl font-bold">Dashboard</h1>
                <p class="text-gray-400 text-sm">Welcome back, Admin</p>
            </div>
            <div class="flex items-center gap-4">
                <span class="text-sm text-gray-400"><?php echo date('l, d M Y'); ?></span>
                <div class="w-10 h-10 bg-gray-700 rounded-full flex items-center justify-center font-bold">A</div>
            </div>
        </header>

        <!-- Stats Grid -->
        <div class="grid grid-cols-4 gap-6 mb-8">
            <!-- Card 1 -->
            <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-gray-400 text-xs font-bold uppercase">Revenue Today</span>
                    <span class="text-green-500 bg-green-500/10 px-2 py-1 rounded text-xs">Live</span>
                </div>
                <h3 class="text-2xl font-bold text-white"><?php echo format_price($stats['revenue_today']); ?></h3>
            </div>
            <!-- Card 2 -->
             <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-gray-400 text-xs font-bold uppercase">Orders Today</span>
                </div>
                <h3 class="text-2xl font-bold text-white"><?php echo $stats['orders_today']; ?></h3>
            </div>
            <!-- Card 3 -->
             <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-gray-400 text-xs font-bold uppercase">Pending Process</span>
                     <span class="text-orange-500 bg-orange-500/10 px-2 py-1 rounded text-xs">Action Needed</span>
                </div>
                <h3 class="text-2xl font-bold text-white"><?php echo $stats['pending_orders']; ?></h3>
            </div>
            <!-- Card 4 -->
             <div class="bg-gray-800 p-6 rounded-2xl border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-gray-400 text-xs font-bold uppercase">Total Users</span>
                </div>
                <h3 class="text-2xl font-bold text-white"><?php echo $stats['total_users']; ?></h3>
            </div>
        </div>

        <!-- Recent Orders -->
        <div class="bg-gray-800 rounded-2xl border border-gray-700 overflow-hidden">
            <div class="p-6 border-b border-gray-700 flex justify-between items-center">
                <h3 class="font-bold text-lg">Recent Orders</h3>
                <a href="orders/order-list.php" class="text-blue-400 text-sm font-bold hover:text-blue-300">View All</a>
            </div>
            <table class="w-full text-left text-sm text-gray-400">
                <thead class="bg-gray-900 uppercase font-bold text-xs text-gray-500">
                    <tr>
                        <th class="px-6 py-4">Order ID</th>
                        <th class="px-6 py-4">Amount</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Date</th>
                        <th class="px-6 py-4">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php if(empty($recentOrders)): ?>
                        <tr><td colspan="5" class="px-6 py-8 text-center text-gray-500">No recent orders found.</td></tr>
                    <?php else: ?>
                        <?php foreach($recentOrders as $order): ?>
                        <tr class="hover:bg-gray-750 transition-colors">
                            <td class="px-6 py-4 font-medium text-white">#<?php echo $order['order_number']; ?></td>
                            <td class="px-6 py-4"><?php echo format_price($order['total_amount']); ?></td>
                            <td class="px-6 py-4">
                                <span class="px-2 py-1 rounded text-xs font-bold uppercase bg-gray-700 text-gray-300">
                                    <?php echo $order['order_status']; ?>
                                </span>
                            </td>
                            <td class="px-6 py-4"><?php echo date('d M Y', strtotime($order['created_at'])); ?></td>
                            <td class="px-6 py-4">
                                <a href="orders/order-details.php?id=<?php echo $order['id']; ?>" class="text-blue-400 hover:text-white font-bold">Manage</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </main>

</body>
</html>
