<?php
// public_html/admin/categories/category-list.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php'; // Bootstrap
require_once ROOT_PATH . '/includes/auth_admin.php';
require_once ROOT_PATH . '/src/Models/Category.php';

$catModel = new Category($pdo);

// Handle Delete Action
if (isset($_POST['delete_id'])) {
    if (!verify_csrf()) die("CSRF Error");
    try {
        $catModel->delete($_POST['delete_id']);
        $success = "Category deleted successfully.";
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

$categories = $catModel->getAll();
$pageTitle = 'Categories';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Categories | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; // Reusable Sidebar ?>

    <main class="ml-64 flex-1 p-8">
        <header class="flex justify-between items-center mb-8">
            <h1 class="text-2xl font-bold">Categories</h1>
            <a href="category-form.php" class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-6 rounded-lg shadow-lg">
                + Add Category
            </a>
        </header>

        <?php if(isset($error)): ?>
            <div class="bg-red-500/10 border border-red-500 text-red-500 p-4 rounded-lg mb-6"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if(isset($success)): ?>
            <div class="bg-green-500/10 border border-green-500 text-green-500 p-4 rounded-lg mb-6"><?php echo $success; ?></div>
        <?php endif; ?>

        <div class="bg-gray-800 rounded-2xl border border-gray-700 overflow-hidden">
            <table class="w-full text-left text-sm text-gray-400">
                <thead class="bg-gray-900 uppercase font-bold text-xs text-gray-500">
                    <tr>
                        <th class="px-6 py-4">ID</th>
                        <th class="px-6 py-4">Image</th>
                        <th class="px-6 py-4">Name</th>
                        <th class="px-6 py-4">Parent</th>
                        <th class="px-6 py-4">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php foreach($categories as $cat): ?>
                    <tr class="hover:bg-gray-750 transition-colors">
                        <td class="px-6 py-4">#<?php echo $cat['id']; ?></td>
                        <td class="px-6 py-4">
                            <img src="<?php echo $cat['image'] ?? 'https://via.placeholder.com/40'; ?>" class="w-10 h-10 rounded-lg object-cover bg-gray-700">
                        </td>
                        <td class="px-6 py-4 font-bold text-white"><?php echo e($cat['name']); ?></td>
                        <td class="px-6 py-4"><?php echo $cat['parent_id'] ? '#' . $cat['parent_id'] : '-'; ?></td>
                        <td class="px-6 py-4 flex gap-4">
                            <a href="category-form.php?id=<?php echo $cat['id']; ?>" class="text-blue-400 hover:text-white font-bold">Edit</a>
                            
                            <form method="POST" onsubmit="return confirm('Delete this category?');" class="inline">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="delete_id" value="<?php echo $cat['id']; ?>">
                                <button type="submit" class="text-red-400 hover:text-red-300 font-bold">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
