<?php
// public_html/admin/categories/category-form.php
require_once dirname(dirname(dirname(__DIR__))) . '/public_html/index.php';
require_once ROOT_PATH . '/includes/auth_admin.php';
require_once ROOT_PATH . '/src/Models/Category.php';

$catModel = new Category($pdo);
$category = null;
$heading = 'Add Category';

// Edit Mode
if (isset($_GET['id'])) {
    $category = $catModel->getById($_GET['id']);
    if (!$category) redirect('category-list.php');
    $heading = 'Edit Category: ' . e($category['name']);
}

// Form Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf()) die("CSRF Error");
    
    $name = trim($_POST['name'] ?? '');
    $parentId = $_POST['parent_id'] ?: null;
    $id = $_POST['id'] ?? null;
    
    // Upload Image
    $imagePath = $category['image'] ?? null;
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        // In Prod: Use move_uploaded_file with security checks
        // For now: Simulate
        // $imagePath = '/uploads/categories/' . time() . '_' . $_FILES['image']['name'];
    }

    try {
        if ($id) {
            $catModel->update($id, $name, $imagePath, $parentId);
        } else {
            $catModel->create($name, $imagePath, $parentId);
        }
        redirect('category-list.php');
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

// Get Parents for Dropdown
$allCats = $catModel->getAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $heading; ?> | Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-gray-100 flex min-h-screen">
    <?php require_once ROOT_PATH . '/public_html/admin/layout/sidebar.php'; ?>

    <main class="ml-64 flex-1 p-8">
        <header class="mb-8">
            <a href="category-list.php" class="text-gray-400 hover:text-white text-sm mb-2 inline-block">&larr; Back to List</a>
            <h1 class="text-2xl font-bold"><?php echo $heading; ?></h1>
        </header>

        <div class="bg-gray-800 p-8 rounded-2xl border border-gray-700 max-w-2xl">
            <?php if(isset($error)): ?>
                <div class="bg-red-500/10 border border-red-500 text-red-500 p-4 rounded-lg mb-6"><?php echo $error; ?></div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php if($category): ?><input type="hidden" name="id" value="<?php echo $category['id']; ?>"><?php endif; ?>

                <div>
                    <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Category Name</label>
                    <input type="text" name="name" value="<?php echo $category['name'] ?? ''; ?>" required class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 focus:border-blue-500 outline-none transition-colors">
                </div>

                <div>
                    <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Parent Category (Optional)</label>
                    <select name="parent_id" class="w-full bg-gray-700 text-white border border-gray-600 rounded-xl px-4 py-3 focus:border-blue-500 outline-none">
                        <option value="">None (Top Level)</option>
                        <?php foreach($allCats as $cat): ?>
                            <?php if($category && $cat['id'] == $category['id']) continue; // Prevent self-parent ?>
                            <option value="<?php echo $cat['id']; ?>" <?php echo (isset($category['parent_id']) && $category['parent_id'] == $cat['id']) ? 'selected' : ''; ?>>
                                <?php echo e($cat['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-400 text-xs font-bold uppercase mb-2">Image</label>
                    <?php if(isset($category['image'])): ?>
                        <img src="<?php echo $category['image']; ?>" class="w-16 h-16 rounded mb-2 object-cover">
                    <?php endif; ?>
                    <input type="file" name="image" class="block w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-bold file:bg-gray-700 file:text-blue-400 hover:file:bg-gray-600">
                </div>

                <div class="flex justify-end pt-4">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 px-8 rounded-xl shadow-lg transition-transform active:scale-95">
                        Save Category
                    </button>
                </div>
            </form>
        </div>
    </main>
</body>
</html>
