<?php
// install/migrate_admin.php
require_once dirname(__DIR__) . '/public_html/index.php';

echo "Running Migration...\n";

try {
    // 1. Create Admins Table
    $sql = "CREATE TABLE IF NOT EXISTS admins (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100),
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        role ENUM('super', 'manager', 'support') DEFAULT 'super',
        is_active TINYINT(1) DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    $pdo->exec($sql);
    echo "[OK] Admins Table Checked/Created.\n";

    // 2. Insert Default Admin (if not exists)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM admins WHERE username = ?");
    $stmt->execute(['admin']);
    if ($stmt->fetchColumn() == 0) {
        $pass = password_hash('password', PASSWORD_BCRYPT);
        $stmt = $pdo->prepare("INSERT INTO admins (name, username, password, role) VALUES (?, ?, ?, ?)");
        $stmt->execute(['Super Admin', 'admin', $pass, 'super']);
        echo "[OK] Default Admin (admin/password) Created.\n";
    } else {
        echo "[SKIP] Default Admin already exists.\n";
    }

} catch (PDOException $e) {
    echo "[ERROR] " . $e->getMessage() . "\n";
}
