<?php
// includes/session.php

// Prevent direct access
if (session_status() === PHP_SESSION_ACTIVE) {
    return;
}

// Session Configuration
ini_set('session.gc_maxlifetime', SESSION_LIFETIME);
ini_set('session.cookie_lifetime', SESSION_LIFETIME);
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);

// Cookie Params
$cookieParams = session_get_cookie_params();
session_set_cookie_params([
    'lifetime' => SESSION_LIFETIME,
    'path' => '/',
    'domain' => $_SERVER['HTTP_HOST'],
    'secure' => isset($_SERVER['HTTPS']), // True if HTTPS
    'httponly' => true,
    'samesite' => 'Strict'
]);

session_name('LUX_SESSID'); // Custom Session Name
session_start();

// Session Fixation & Hijacking Prevention
if (!isset($_SESSION['CREATED'])) {
    $_SESSION['CREATED'] = time();
} else if (time() - $_SESSION['CREATED'] > 1800) {
    // Regenerate ID every 30 mins
    session_regenerate_id(true);
    $_SESSION['CREATED'] = time();
}

// Bind to User Agent
if (!isset($_SESSION['USER_AGENT'])) {
    $_SESSION['USER_AGENT'] = $_SERVER['HTTP_USER_AGENT'];
} else if ($_SESSION['USER_AGENT'] !== $_SERVER['HTTP_USER_AGENT']) {
    // Possible Hijack
    session_destroy();
    session_start();
}
