<?php
// includes/maintenance_check.php

// Ensure DB $pdo is available
if (!isset($pdo)) {
    return;
}

// Bypass for Admin Logs/Actions
if (strpos($_SERVER['REQUEST_URI'], '/admin') !== false) {
    return;
}

try {
    // Check Settings Table
    // Assuming table 'settings' has key 'maintenance_mode' value '1' or '0'
    $stmt = $pdo->prepare("SELECT value FROM settings WHERE key_name = 'maintenance_mode'");
    $stmt->execute();
    $mode = $stmt->fetchColumn();

    if ($mode === '1') {
        // If Maintenance is ON
        
        // Check if user is admin (bypass)
        // Check session role
        if (isset($_SESSION['user']['role']) && $_SESSION['user']['role'] === 'admin') {
            return; 
        }

        // Redirect to maintenance page if not already there
        if (strpos($_SERVER['PHP_SELF'], 'maintenance.php') === false) {
            header("Location: " . BASE_URL . "/maintenance.php");
            exit;
        }
    }

} catch (PDOException $e) {
    // If DB check fails, log it but don't crash site unless DB is totally down
    // Use config/database.php logging
    error_log("Maintenance Check Failed: " . $e->getMessage());
}
