<?php
// cron.php
// Run this file via CRON every hour: 0 * * * * php /path/to/cron.php

define('IS_CRON', true);
require_once __DIR__ . '/public_html/index.php';

echo "[CRON] Starting Job at " . date('Y-m-d H:i:s') . "\n";

try {
    // 1. Cleanup Old OTPs (Older than 1 hour)
    $stmt = $pdo->exec("DELETE FROM otp_logs WHERE created_at < DATE_SUB(NOW(), INTERVAL 1 HOUR)");
    echo "[CLEANUP] Deleted $stmt old OTP logs.\n";

    // 2. Cleanup Old Sessions (DB based if implemented, otherwise PHP handles file gc)
    
    // 3. Mark 'Delivered' orders as 'Completed' after return window (e.g. 7 days)
    // This locks the order from returns.
    $stmt = $pdo->exec("UPDATE orders SET order_status = 'completed' WHERE order_status = 'delivered' AND updated_at < DATE_SUB(NOW(), INTERVAL 7 DAY)");
    echo "[ORDERS] Auto-completed $stmt orders.\n";

    // 4. Optimize Tables (Optional)
    // $pdo->exec("OPTIMIZE TABLE orders, users, wallet_transactions");

    echo "[CRON] Finished Successfully.\n";

} catch (Exception $e) {
    echo "[ERROR] Cron Failed: " . $e->getMessage() . "\n";
    error_log("Cron Error: " . $e->getMessage());
}
