<?php
// config/database.php

require_once __DIR__ . '/env.php';

try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
        PDO::ATTR_PERSISTENT         => true
    ];

    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);

} catch (PDOException $e) {
    // Log error securely
    error_log("Database Connection Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    
    // Friendly error for user (if production)
    if (SITE_ENV === 'production') {
        http_response_code(500);
        die("<h1>System Error</h1><p>The database service is currently unavailable. Please try again later.</p>");
    } else {
        die("DB Connection Failed: " . $e->getMessage());
    }
}
