<?php
// config/config.php

// 1. Timezone & Locale
date_default_timezone_set('Asia/Kolkata'); // Target audience timezone
setlocale(LC_MONETARY, 'en_IN');

// 2. Paths
define('ROOT_PATH', dirname(__DIR__));
define('PUBLIC_PATH', ROOT_PATH . '/public_html');
define('LOG_PATH', ROOT_PATH . '/logs');
define('UPLOAD_PATH', PUBLIC_PATH . '/uploads');

// 3. URLs
// Auto-detect base URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
define('BASE_URL', $protocol . $host);
define('APP_URL', BASE_URL); // Alias

// 4. Site Info
define('SITE_NAME', 'LuxeStyle');
define('DEFAULT_CURRENCY', '₹');

// 5. Session Configuration
define('SESSION_LIFETIME', 86400 * 30); // 30 Days

// 6. Error Reporting
if (defined('SITE_ENV') && SITE_ENV === 'production') {
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', LOG_PATH . '/error.log');
    error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);
} else {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
}

// Ensure Log Directory Exists
if (!is_dir(LOG_PATH)) {
    mkdir(LOG_PATH, 0755, true);
}
